﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;
using Gemini.Core.BL.Interface;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodStatsView : BaseAPIMethod
        {

            public MethodStatsView(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "statsview"; }
            }

            private int _studentId = 0;

            protected override bool DoValidate()
            {
                return true;
            }

            protected override void DoReadRequestParams()
            {
                string _student_Id = Component.APIRequestParams["student_id"];
                if (!string.IsNullOrEmpty(_student_Id))
                {
                    int.TryParse(_student_Id, out _studentId);
                }
            }

            protected override GResponseData DoGetGResponseData()
            {
                if (User != null)
                {
                    FM.N001.Account.BL.BO.View.User _statsUser = User;
                    BL.Dictionary.GroupType _group = (BL.Dictionary.GroupType)User.GroupEnumID;
                    if ((_group == PI.ZB.N1200.ELearning.BL.Dictionary.GroupType.Instructor) && (_studentId > 0))
                    {
                        _statsUser = Component.BLELearning.RBL.Account.User.View.Restore(_studentId);
                    }

                    List<GStatsValue> _statsList = Component.BLELearning.APIMobile.GetStatsData(_statsUser);
                    if (_statsList != null)
                    {
                        StatusCode = StatusCodeType.OK;
                        return new GResponseData_StatsView() { Stats = _statsList };
                    }
                    else
                    {
                        AddErrorMessage("Nie znaleziono statystyk dla ucznia.");
                        StatusCode = StatusCodeType.NotFound;
                    }
                }
                return null;
            }
        }
    }
}